// (C)1997 Christian Janoff

#ifndef _C1541_H
#define _C1541_H 1

#include <fstream.h>
#include "pkstring.h"

int nbsectors_of_track(int tracknumber);

class c1541sector
{
  public:  int   get_byte(int);
	   void  put_byte(int, int);
  private: int   sectordata[256];
};

class c1541track
{
  public:               c1541track(int);
                        ~c1541track();
                    int get_byte(int, int);
                   void put_byte(int, int, int);
  private:  c1541sector *sector;

};

class c1541disk
{
 public:           c1541disk();
                   ~c1541disk();
               int is_equal_to(c1541disk& other);
               int get_byte(int, int, int);
              void put_byte(int, int, int, int);
	       int zipcode(pkstring , int);
              void d64(char *, int);
	      void set_verbose(int);
	      void set_more_verbose(int);
	      void set_yes(int);
	      void dump_sector(int, int);

 private:  fstream io;
	   enum { nbtracks=35,
		  nbsectors=683 };
       c1541track* track[nbtracks+1];
        static int option_verbose;
        static int option_more_verbose;
	static int option_yes;

              void iofile_open(char *,int mode);
              void iofile_close(void);
               int iofile_get_byte(void);
              void iofile_put_byte(int);
              void iofile_skip_bytes(int);

               int interleave_sector(int, int);
              void open_zipcode_file(char *filename, char number, int mode);
              void close_zipcode_file(void);

	       int zipcode_read_sectordata(int filenumber);
              void zipcode_error(char*);
               int zipdecode_rle_method(int, int);
              void zipdecode_fill_method(int, int);
              void zipdecode_write_through_method(int, int);

              void zipcode_write_sectordata(int, int);
              void zipwrite_fill_method(int, int, int);
              void zipwrite_write_through_method(int, int);
               int zipwrite_rle_method(int, int, int, int);
               int zipcode_find_marker(int, int);

};

#endif // _C1541_H
